/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.catalyst.ICatalystMatcher;
import dev.compactmods.crafting.api.components.IRecipeComponent;
import dev.compactmods.crafting.api.components.RecipeComponentType;
import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import dev.compactmods.crafting.api.recipe.layers.IRecipeLayer;
import dev.compactmods.crafting.api.recipe.layers.RecipeLayerType;
import dev.compactmods.crafting.api.recipe.layers.dim.IFixedSizedRecipeLayer;
import dev.compactmods.crafting.recipes.MiniaturizationRecipe;
import dev.compactmods.crafting.recipes.catalyst.CatalystMatcherCodec;
import dev.compactmods.crafting.recipes.catalyst.ItemStackCatalystMatcher;
import dev.compactmods.crafting.recipes.components.RecipeComponentTypeCodec;
import dev.compactmods.crafting.recipes.layers.RecipeLayerTypeCodec;
import dev.compactmods.crafting.server.ServerConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;

public class MiniaturizationRecipeCodec
implements Codec<MiniaturizationRecipe> {
    public static final Codec<IRecipeLayer> LAYER_CODEC = RecipeLayerTypeCodec.INSTANCE.dispatchStable(IRecipeLayer::getType, RecipeLayerType::getCodec);
    public static final Codec<IRecipeComponent> COMPONENT_CODEC = RecipeComponentTypeCodec.INSTANCE.dispatchStable(IRecipeComponent::getType, RecipeComponentType::getCodec);

    MiniaturizationRecipeCodec() {
    }

    public <T> DataResult<Pair<MiniaturizationRecipe, T>> decode(DynamicOps<T> ops, T input) {
        boolean debugOutput = (Boolean)ServerConfig.RECIPE_REGISTRATION.get();
        if (debugOutput) {
            CompactCrafting.RECIPE_LOGGER.debug("Starting recipe decode: {}", (Object)input.toString());
        }
        MiniaturizationRecipe recipe = new MiniaturizationRecipe();
        StringBuilder errorBuilder = new StringBuilder();
        int recipeSize = (Integer)Codec.INT.optionalFieldOf("recipeSize", (Object)-1).codec().parse(ops, input).result().get();
        recipe.setRecipeSize(recipeSize);
        DataResult layers = LAYER_CODEC.listOf().fieldOf("layers").codec().parse(ops, input);
        if (layers.error().isPresent()) {
            Optional partialLayers = layers.resultOrPartial(errorBuilder::append);
            partialLayers.ifPresent(recipe::applyLayers);
            return DataResult.error((String)errorBuilder.toString(), (Object)Pair.of((Object)recipe, input), (Lifecycle)Lifecycle.stable());
        }
        List<IRecipeLayer> layerList = layers.resultOrPartial(errorBuilder::append).orElse(Collections.emptyList());
        recipe.applyLayers(layerList);
        boolean hasFixedLayers = layerList.stream().anyMatch(l -> l instanceof IFixedSizedRecipeLayer);
        if (debugOutput) {
            CompactCrafting.RECIPE_LOGGER.debug("Number of layers defined: {}", (Object)layerList.size());
            CompactCrafting.RECIPE_LOGGER.debug("Is fixed size: {}", (Object)hasFixedLayers);
        }
        if (!hasFixedLayers && !MiniaturizationFieldSize.canFitDimensions(recipeSize)) {
            errorBuilder.append("Specified recipe size will not fit in a crafting field: ").append(recipeSize);
            return DataResult.error((String)errorBuilder.toString(), (Object)Pair.of((Object)recipe, input), (Lifecycle)Lifecycle.stable());
        }
        recipe.recalculateDimensions();
        Optional catalystNode = ops.get(input, "catalyst").result();
        if (catalystNode.isEmpty()) {
            if (debugOutput) {
                CompactCrafting.LOGGER.warn("No catalyst node defined in recipe; this is likely a bad file!");
            }
        } else {
            Optional catalystType = ops.get(catalystNode.get(), "type").result();
            if (catalystType.isEmpty()) {
                if (debugOutput) {
                    CompactCrafting.LOGGER.warn("Error: no catalyst type defined; falling back to the itemstack handler.");
                }
                ItemStack stackData = ItemStack.f_41582_.fieldOf("catalyst").codec().parse(ops, input).resultOrPartial(errorBuilder::append).orElse(ItemStack.f_41583_);
                recipe.setCatalyst(new ItemStackCatalystMatcher(stackData));
            } else {
                ICatalystMatcher catalyst = CatalystMatcherCodec.MATCHER_CODEC.fieldOf("catalyst").codec().parse(ops, input).resultOrPartial(errorBuilder::append).orElse(new ItemStackCatalystMatcher(ItemStack.f_41583_));
                recipe.setCatalyst(catalyst);
            }
        }
        Optional outputs = ItemStack.f_41582_.listOf().fieldOf("outputs").codec().parse(ops, input).resultOrPartial(errorBuilder::append);
        outputs.ifPresent(recipe::setOutputs);
        if (!outputs.isPresent()) {
            return DataResult.error((String)errorBuilder.toString(), (Object)Pair.of((Object)recipe, input), (Lifecycle)Lifecycle.stable());
        }
        if (recipe.getOutputs().length == 0) {
            errorBuilder.append("No outputs were defined.");
            return DataResult.error((String)errorBuilder.toString(), (Object)Pair.of((Object)recipe, input), (Lifecycle)Lifecycle.stable());
        }
        Optional components = Codec.unboundedMap((Codec)Codec.STRING, COMPONENT_CODEC).optionalFieldOf("components", Collections.emptyMap()).codec().parse(ops, input).resultOrPartial(errorBuilder::append);
        components.ifPresent(compNode -> {
            CompactCrafting.RECIPE_LOGGER.trace("Got components map; checking any exist and applying to recipe.");
            recipe.applyComponents((Map<String, IRecipeComponent>)compNode);
        });
        if (debugOutput) {
            CompactCrafting.RECIPE_LOGGER.debug("Finishing recipe decode.");
        }
        return DataResult.success((Object)Pair.of((Object)recipe, input), (Lifecycle)Lifecycle.stable());
    }

    public <T> DataResult<T> encode(MiniaturizationRecipe recipe, DynamicOps<T> ops, T prefix) {
        DataResult catalyst;
        if (recipe == null) {
            return DataResult.error((String)"Cannot serialize a null recipe.");
        }
        DataResult layers = LAYER_CODEC.listOf().encodeStart(ops, recipe.getLayerListForCodecWrite());
        DataResult components = Codec.unboundedMap((Codec)Codec.STRING, COMPONENT_CODEC).encodeStart(ops, recipe.getComponents().getAllComponents());
        ICatalystMatcher catalystItem = recipe.getCatalyst();
        if (catalystItem != null) {
            catalyst = CatalystMatcherCodec.MATCHER_CODEC.encodeStart(ops, (Object)catalystItem);
        } else {
            CompactCrafting.RECIPE_LOGGER.warn("Catalyst appears to be missing.");
            catalyst = DataResult.success(null);
        }
        DataResult outputs = ItemStack.f_41582_.listOf().encodeStart(ops, (Object)ImmutableList.copyOf((Object[])recipe.getOutputs()));
        RecordBuilder builder = ops.mapBuilder();
        builder.add("type", Codec.STRING.encodeStart(ops, (Object)"compactcrafting:miniaturization"));
        if (recipe.hasSpecifiedSize()) {
            builder.add("recipeSize", Codec.INT.encodeStart(ops, (Object)recipe.getRecipeSize()));
        }
        RecordBuilder b = builder.add("layers", layers).add("components", components);
        if (catalystItem != null) {
            b.add("catalyst", catalyst);
        }
        return b.add("outputs", outputs).build(prefix);
    }
}

